//
//  DelayedInitializable.swift
//  Do It
//
//  Created by Jim Dovey on 11/3/18.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

// These come from the property wrappers proposal:
// https://github.com/apple/swift-evolution/blob/master/proposals/0258-property-wrappers.md#delayed-initialization

@propertyWrapper
struct DelayedMutable<Value> {
    private var _value: Value?
    init() { _value = nil }

    var wrappedValue: Value {
        get {
            guard let value = _value else {
                preconditionFailure("property accessed before initialization")
            }
            return value
        }
        set {
            _value = newValue
        }
    }

    var initialized: Bool { _value != nil }
}

@propertyWrapper
struct DelayedImmutable<Value> {
    private var _value: Value?
    init() { _value = nil }

    var wrappedValue: Value {
        get {
            guard let value = _value else {
                preconditionFailure("property accessed before initialization")
            }
            return value
        }
        set {
            if _value != nil {
                preconditionFailure("property already initialized")
            }
            _value = newValue
        }
    }

    var initialized: Bool { _value != nil }
}
